/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWConfigIndexPropertyDialog
extends VWModalDialog
implements ActionListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    private VWAddRemovePanel m_indexPanel = null;
    private JTextField m_indexNameTextField = new JTextField();
    private JButton m_OKButton = new JButton(VWResource.OK);
    private JButton m_cancelButton = new JButton(VWResource.Cancel);
    private JButton m_helpButton = new JButton(VWResource.Help);
    private IVWTableDefinition m_tableDef = null;
    private VWIndexDefinition m_indexDefinition = null;
    private int m_nRetStatus = 1;

    public VWConfigIndexPropertyDialog(Frame parent, IVWTableDefinition tableDef, VWIndexDefinition indexDef) {
        super(parent);
        try {
            this.setTitle(VWResource.IndexProperties);
            Dimension dim = VWStringUtils.stringToDimension("715,495");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.createTopPanel(), "First");
            this.m_indexPanel = new VWAddRemovePanel(48);
            this.getContentPane().add((Component)this.m_indexPanel, "Center");
            this.m_tableDef = tableDef;
            this.m_indexDefinition = indexDef;
            Object[] indexFieldNames = null;
            if (this.m_indexDefinition != null) {
                this.m_indexNameTextField.setText(this.m_indexDefinition.getName());
                this.m_indexNameTextField.setEditable(false);
                indexFieldNames = this.m_indexDefinition.getFieldNames();
            }
            VWExposedFieldDefinition[] exposedFields = this.m_tableDef.getFields();
            Object[] exposedFieldNames = new String[exposedFields.length];
            for (int nIndex = 0; nIndex < exposedFields.length; ++nIndex) {
                exposedFieldNames[nIndex] = exposedFields[nIndex].getName();
            }
            this.m_indexPanel.initializeLists(exposedFieldNames, indexFieldNames);
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.m_OKButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getReturnStatus() {
        return this.m_nRetStatus;
    }

    public VWIndexDefinition getUpdatedIndex() {
        return this.m_indexDefinition;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            try {
                String[] fieldNames = null;
                Object[] selectedItems = this.m_indexPanel.getSelectedItems();
                if (selectedItems != null && selectedItems.length > 0) {
                    fieldNames = new String[selectedItems.length];
                    for (int nIndex = 0; nIndex < selectedItems.length; ++nIndex) {
                        fieldNames[nIndex] = (String)selectedItems[nIndex];
                    }
                }
                if (this.m_indexDefinition == null) {
                    this.m_indexDefinition = this.m_tableDef.createIndexDefinition(this.m_indexNameTextField.getText(), fieldNames);
                } else {
                    this.m_indexDefinition.setFieldNames(fieldNames);
                }
                this.m_nRetStatus = 0;
                this.setVisible(false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc060.htm");
        }
    }

    public void releaseResources() {
        if (this.m_indexPanel != null) {
            this.m_indexPanel.removeReferences();
            this.m_indexPanel = null;
        }
        if (this.m_indexNameTextField != null) {
            this.m_indexNameTextField.removeAll();
            this.m_indexNameTextField = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_tableDef = null;
        this.m_indexDefinition = null;
        this.removeAll();
    }

    private JPanel createTopPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(4, 4, 4, 4);
            JLabel label = new JLabel(VWResource.Index_name);
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, mainPanel, VWResource.Index_name, VWResource.Index_name);
            gbConst.weightx = 1.0;
            mainPanel.add((Component)this.m_indexNameTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_indexNameTextField, mainPanel, VWResource.Index_name, VWResource.Index_name);
            VWAccessibilityHelper.setLabelFor(label, this.m_indexNameTextField);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_OKButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, mainPanel, this.m_OKButton.getText(), this.m_OKButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, mainPanel, this.m_cancelButton.getText(), this.m_cancelButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, mainPanel, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }
}

